/********************* (C) COPYRIGHT 2010 e-Design Co.,Ltd. ********************
 File Name : Menu.c  
 Version   : DS203_APP Ver 2.4x                                  Author : bure
*******************************************************************************/
#include <math.h>
#include <string.h>
#include "Interrupt.h"
#include "Function.h"
#include "Process.h"
#include "Menu.h"
#include "Draw.h"
#include "BIOS.h"
#include "USART.h"


I32STR_RES Num;
u8 Curr_Status=S_Title,CurrCom;
u8 display_flag=1;
u8 Notice_Flag=0;
u16 Result_FPS;
u8 ITEM1=0,ITEM2=MENU_ITEM;
u8 V_Unit[4][3]={"uV","mV","V ","kV"};
u8 T_Unit[5][3]={"nS","uS","mS","S ","  "};
u8 F_Unit[5][4]={"Hz","Hz","KC","MC","  "};

uc8 STATESTR[2][10] = {"!RUN ", "!HOLD"};                          // Running state str

uc16 S_Inv[2]       = {(SCRN<<4)+TEXT2, (SCRN<<4)+NOTE1};         // Running state Color

uc8 BATT_STR[5][10] = {"!~``'", "!~``}", "!~`;}", "!~;;}", "!{;;}"};   // Battery Status Str
uc16 B_COLOR[5]     = {(NOTE1<<4)+SCRN, (SIDE <<4)+SCRN,
                       (TEXT2<<4)+SCRN, (TEXT2<<4)+SCRN,
                       (TEXT2<<4)+SCRN};                          // Battery Status Color

uc8 CH_A_STR[2][10]  = {" HIDE ", "!CH(A)!"};
uc8 CH_B_STR[2][10]  = {" HIDE ", "!CH(B)!"};
uc8 CH_C_STR[2][10]  = {"!HIDE!", "CH(C)"};
uc8 CH_D_STR[10][10] = {"!HIDE!", "CH(D)", "(A+B)", "(A-B)",  
                     "(C&D)", "(C|D)", "REC_A",  "REC_B",
                        "REC_C",  "REC_D"};                      // Track source Str
uc8 NO_RANGE[5]      = " -- ";                       
uc8 NO_DEF[5]        = "--";                       

uc8  YCOUPLE[3][10]  = {" -- "," DC ", " AC "};                        // Track Couple Str!---!                    
u8   Vertical[15][10];                                             // Track Range Str
uc8  YPOSISTR[5]    = {"YPOS"};  //SCRN  

uc16 Y_INV[5]       = {(SCRN<<4)+TR_1, (SCRN<<4)+TR_2,
                       (SCRN<<4)+TR_3, (SCRN<<4)+TR_4,
                       (SCRN<<4)+VERNIE};                          // Track Color 1
uc16 Y_COLOR[5]     = {(TR_1<<4)+SCRN, (TR_2<<4)+SCRN,
                       (TR_3<<4)+SCRN, (TR_4<<4)+SCRN,
                       (VERNIE<<4)+SCRN};                          // Track Color 2

uc8 MODESTR[5][10]  = {"!AUTO!", "!NORM!", "SINGL", "!NONE!",
                       "!SCAN!"};                                  // Sync Mode Str
u8   BaseStr[30][10];                                              // Time Base b Str
uc8  XPOSISTR[5]    = {"XPOS"};
uc16 XCOLOR[2]      = {(SCRN<<4)+X_POSI, (X_POSI<<4)+SCRN};        // Time Base Color

uc8 FO_TYPE[4][10]  = {" SINE ",  "Triang",  " !Saw! ",  "Square"}; // Output Kind Str  "Kd=  %"

uc8 FO_STR[20][10]  = {" 10Hz ",  " 20Hz ",  " 50Hz ",   " 100Hz",
                       "!200Hz!", "!500Hz!", " 1KHz ",   " 2KHz ",
                       " 5KHz ",  "!10KHz!", "!20KHz!",  "!50KHz!",
                       "100KHz",  "200KHz",  "500KHz",   " 1MHz ",
                       " 2MHz ",  " 4MHz ",  " 6MHz ",   " 8MHz "}; // Output Frequency Str

uc16 O_COLOR[2]     = {(SCRN<<4)+TEXT3, (TEXT3<<4)+SCRN};         // Output Frequency Color

uc8  TRIGSTR[8][10] = {"TRIGG", "TRIGG", "TRIGG", "TRIGG" };     // Trigger source Str
                          
uc8  TR_TYPE[8][5] = {":!\\!", ":!^!", "<Vt", ">Vt",            // Trigger Type Str
                       "<TL",   ">TL",  "<TH", ">TH"};
uc8  VT_STR[9]      =  "THRESHOL";                                // Trigg Voltage Str
                          
uc8  VERNIE1[5]     = {"!V1!"};          // V1 Vernie Str
uc8  VERNIE2[5]     = {"!V2!"};          // V2 Vernie Str
uc8  VERNIE3[5]     = {"!T1!"};          // T1 Vernie Str
uc8  VERNIE4[5]     = {"!T2!"};          // T2 Vernie Str
uc8  EXT_STR[2][5]  = {"EXT","SAV"};




uc16 V_INV[1]       = {(SCRN<<4)+VERNIE};
uc16 V_COLOR[1]     = {(VERNIE<<4)+SCRN};                         // Y Vernie Color
uc16 T_INV[1]       = {(SCRN<<4)+VERNIE};
uc16 T_COLOR[1]        = {(VERNIE<<4)+SCRN};                         // X Vernie Color
uc8  F_FUNC[2][10]  = {"Save File", "Load File"};                 // File Function Str

uc8  F_EXT[8][10]   = {".BMP?", ".DAT?", ".BUF?",".CSV?", " OK! ",
                         " ERR!",".HEX", ".BIN",};                  // File Ext Name Str
uc16 F_INV[1]       = {(SCRN<<4)+TEXT1};                          //  File Color
uc8  DELTA_V[2][10] = {"[V:", "[V:"};
uc8  DELTA_T[4]     = "[T:";
uc8  METER[14][5]   = {"Vbt", "FPS","Vpp", "Vdc", "RMS",  "Max", "Min", "FRQ", 
                       "CIR", "DUT", "!TH!", "!TL!","EXT","SAV"};

u8   NumStr[9], Detail[14];
u8   Current = 0, TypeA = 0, Update = 1;
u8   BL_Str[5]="B.L", Vol_Str[5]="Vol";
u8 Current1 = 13;
menu Title[13][4]=   
{
  //     Item_String,   m_Color,   Limit, Mark, xPos, yPos, Value, Flag 
  {//============================ Title Track1 Group ===========================
    {(u8*)YCOUPLE, (u16*)Y_INV,     3-1, CIRC,   36,  228,     1, UPDAT}, //  Track Couple  Y_COLOR     
    {(u8*)Vertical,(u16*)Y_COLOR,   8-1,    0,   36,  216,     1, UPDAT}, //  Track Range  
    {(u8*)YPOSISTR,(u16*)Y_INV,     198,  FIX,   320,  228,   120, UPDAT}, //  Adj. Track Position 160
   {(u8*)CH_A_STR,(u16*)Y_INV,     2-1,  NOT,   0,  0,     1, UPDAT}, //  Track source
   
  },
  {//============================ Title Track2 Group ===========================
    {(u8*)YCOUPLE, (u16*)Y_INV+1,   3-1, CIRC,   68,  228,     1, UPDAT}, //  Track Couple   Y_COLOR     
    {(u8*)Vertical,(u16*)Y_COLOR+1, 8-1,    0,   68,  216,     1, UPDAT}, //  Track Range
    {(u8*)YPOSISTR,(u16*)Y_INV+1,   198,  FIX,   320, 228,   100, UPDAT}, //  Adj. Track Position
    {(u8*)CH_B_STR,(u16*)Y_INV+1,   2-1, NOT,    86,  216,     1, UPDAT}, //  Track source
  },
  {//============================ Title Track3 Group ===========================
    {(u8*)CH_C_STR,(u16*)Y_INV+2,   2-1, CIRC,  102,  228,     1, UPDAT}, //  Track source
    {(u8*)NO_DEF , (u16*)Y_COLOR+2, 1-1,  NOT,  102,  216,     0, UPDAT}, //  Track Couple        
    {(u8*)NO_RANGE,(u16*)Y_COLOR+2, 1-1,  NOT,  153,  216,     0, UPDAT}, //  Track Range
    {(u8*)YPOSISTR,(u16*)Y_INV+2, 200-1,  FIX,  320,  228,    60, UPDAT}, //  Adj. Track Position
  },
  {//============================ Title Track4 Group ===========================
    {(u8*)CH_D_STR,(u16*)Y_INV+3,  10-1, CIRC,  144,  228,     1, UPDAT}, //  Track source
    {(u8*)NO_DEF , (u16*)Y_COLOR+3, 1-1,  NOT,  144,  216,     0, UPDAT}, //  Track Couple        
    {(u8*)NO_RANGE,(u16*)Y_COLOR+3, 1-1,  NOT,  204,  216,     0, UPDAT}, //  Track Range
    {(u8*)YPOSISTR,(u16*)Y_INV+3, 200-1,  FIX,  320,  228,    20, UPDAT}, //  Adj. Track Position
  },
  {//================== Running State & Battery Status Group ===================
    {(u8*)STATESTR,(u16*)S_Inv,     2-1,    0,    0,  228,     0, UPDAT}, //  Running state
    {(u8*)BATT_STR,(u16*)B_COLOR,   5-1,    0,    0,  216,     0, UPDAT}, //  Battery status
    {(u8*)BATT_STR,(u16*)B_COLOR,   5-1,  NOT,    0,  216,     0,   HID}, 
    {(u8*)BATT_STR,(u16*)B_COLOR,   5-1,  NOT,    0,  216,     0,   HID},
  },
  {//========================= Title Time Base Group ===========================
    {(u8*)MODESTR, (u16*)XCOLOR,    5-1, CIRC,  182,  228,     0, UPDAT}, //  Sync Mode
    {(u8*)BaseStr, (u16*)XCOLOR+1, 27-1,    0,  182,  216,    17, UPDAT}, //  Time Base Range
    {(u8*)XPOSISTR,(u16*)XCOLOR,   127,  FIX,  352,  228,     0, UPDAT}, //  Adj. X position
    {(u8*)XPOSISTR,(u16*)XCOLOR,   127,    CIRC,  80,   0,     0, UPDAT}, //  View window rule3795
  },           
  {//======================= Title Output Signal Group =========================
    {(u8*)FO_TYPE, (u16*)O_COLOR,   4-1, CIRC,  220,  228,     3, UPDAT}, //  Output Wave Kind      
    {(u8*)FO_STR,  (u16*)O_COLOR+1,20-1,    0,  268,  228,    13, UPDAT}, //  Output Frequency         
    {(u8*)NumStr,  (u16*)O_COLOR,   100,  NOT,  306,  228,    50,   HID},        
    {(u8*)NumStr,  (u16*)O_COLOR,     0,  NOT,    0,    0,     0,   HID}, //  Duty value 
       
  },
  {//=====================;===== Title Trigger Group ====;======================
    {(u8*)TRIGSTR, (u16*)Y_INV,     4-1, CIRC,  294,  188,     1, UPDAT}, //  Trigger source         
    {(u8*)TR_TYPE, (u16*)Y_INV,     8-1, CIRC,  344,  188,     0, UPDAT}, //  Trigger Kine         
    {(u8*)VT_STR,  (u16*)Y_INV,     200,  FIX,  294,  172,     0, UPDAT}, //  Adj. Trigger threshold  Y_COLOR   
    {(u8*)VT_STR,  (u16*)Y_INV,       0,  NOT,  294,  172,     0, HID}, //  Number position   HID NOT    
  },
  {//============================ Title Y Vernie Group =========================
    {(u8*)VERNIE1, (u16*)V_INV,   200-1,  FIX,  294,  156,   180, UPDAT}, //  V1 Vernie         
    {(u8*)VERNIE2, (u16*)V_INV,   200-1,  FIX,  294,  140,    40, UPDAT}, //  V2 Vernie     
    {(u8*)DELTA_V, (u16*)Y_INV,     2-1, CIRC,  334,  156,     0, UPDAT}, //  Measure Track    
    {(u8*)NumStr,  (u16*)Y_INV,     240, NUM3,  334,  140,    70, UPDAT}, //  Delta V value 
     
  },
  {//============================ Title X Vernie Group =========================
    {(u8*)VERNIE3, (u16*)T_INV,     300,  FIX,  294,   124,    80, UPDAT}, //  T1 Vernie         
    {(u8*)VERNIE4, (u16*)T_INV,     300,  FIX,  294,   108,   280, UPDAT}, //  T2 Vernie     
    {(u8*)DELTA_T, (u16*)T_INV,       0,  NOT,  334,   124,     0, UPDAT}, //  Delta T Str     
    {(u8*)NumStr,  (u16*)T_INV,     300, NUM3,  334,   108,    80, UPDAT}, //  Delta T value  T_COLOR  
  },
  {//============================= Title File Group ============================
    {(u8*)F_FUNC,  (u16*)F_INV,     2-1, CIRC,  134,    0,     0,     0}, //  File function    
    {(u8*)NumStr,  (u16*)F_INV,   256-1, NUM3,  206,    0,     0,     1}, //  File number     
    {(u8*)F_EXT,   (u16*)F_INV,     4-1, CIRC,  230,    0,     0,     0}, //  Ext. name     
    {(u8*)F_EXT,   (u16*)F_INV,       0,  NOT,    0,    0,     0,   HID},  
  },
  
  {//=========================== Title BackLight Group =========================
    {(u8*)BL_Str,  (u16*)V_INV,     1-1,  FIX,  314,  167,     0, UPDAT}, //  BackLight    
    {(u8*)NumStr,  (u16*)V_COLOR,  10-1, NUM2,  342,  167,     5, UPDAT}, //  Class     
    {(u8*)NumStr,  (u16*)V_INV,       0,  NOT,    0,    0,     0,   HID},     
    {(u8*)NumStr,  (u16*)V_INV,       0,  NOT,    0,    0,     0,   HID},  
  },
  {//============================ Title Volume Group ===========================
    {(u8*)Vol_Str, (u16*)V_INV,     1-1,  FIX,  314,  152,     0, UPDAT}, //  Volume        
    {(u8*)NumStr,  (u16*)V_COLOR,  11-1, NUM2,  342,  152,     5, UPDAT}, //  Class     
    {(u8*)NumStr,  (u16*)V_INV,       0,  NOT,    0,    0,     0,   HID},    
    {(u8*)NumStr,  (u16*)V_INV,       0,  NOT,    0,    0,     0,   HID},    
  },
};

meter Meter[9] =
{ //{(u8*)METER,      4,    VBT,     340,    370,   164,  UPDAT}, //  Meter #0
  {(u8*)METER,      4,    VBT,     340,    370,   148,  UPDAT}, //  Meter #1
  {(u8*)METER, TRACK4,    FRQ,     340,    370,   132,  UPDAT}, //  Meter #2   FPS 
  {(u8*)METER, TRACK3,    CIR,     340,    370,   116,  UPDAT}, //  Meter #3    
  {(u8*)METER, TRACK3,    DUT,     340,    370,   100,  UPDAT}, //  Meter #4       
  {(u8*)METER, TRACK2,    TH,      340,    370,    84,  UPDAT}, //  Meter #5
  {(u8*)METER, TRACK2,    TL,      340,    370,    68,  UPDAT}, //  Meter #6
  {(u8*)METER, TRACK1,    VPP,     340,    370,    52,  UPDAT}, //  Meter #7
  {(u8*)METER, TRACK1,    VDC,     340,    370,    36,  UPDAT}, //  Meter #8
  {(u8*)METER,      4,    Ext,     340,    370,    20,  UPDAT},  //EXt
};         

trigger Trigg[14]=
{//========================== Title Trigger Group ===========================  
  //Item: String,  Ttack,  yPos, xPos,  Limit1, Limit2, Value1, Value2, Flag 
//===============  ======  ====  =====  ======  ======  ======   =====  =====
    {(u8*)TRIGSTR, TRACK1, 188,   286,    0,        0,      1,      0,  UPDAT}, //  Trigger source         
    {(u8*)TR_TYPE, TRACK1, 188,   334,    0,      8-1,      0,      0,  UPDAT},  //  Trigger Kine 

    {(u8*)VT_STR,  TRACK1, 172,   286,    2,    200-2,     53,      0,  UPDAT}, //  Adj. Trigger threshold  Y_COLOR  
//============================ Title Y Vernie Group =========================
    {(u8*)VERNIE1,      4, 156,   286,    2,    200-2,    180,      0,  UPDAT}, //  V1 Vernie         
    {(u8*)VERNIE2,      4, 140,   286,    2,    200-2,     40,      0,  UPDAT}, //  V2 Vernie 
//============================ Title X Vernie Group =========================        
    {(u8*)VERNIE3,      4, 124,   286,    2,    360-2,     80,      0,  UPDAT}, //  T1 Vernie         
    {(u8*)VERNIE4,      4, 108,   286,    2,    360-2,    280,      0,  UPDAT}, //  T2 Vernie 
//=========================== Title BackLight Group =========================
    {(u8*)BL_Str,       4,  92,   286,    0,        9,      5,      0, UPDAT}, //  BackLight 
//============================ Title Volume Group ===========================     
    {(u8*)Vol_Str,      4,  76,   286,    0,       10,      5,      0, UPDAT}, //  Volume 
//----------------------------Exit--------------------------------------------------         
    {(u8*)EXT_STR,      4,  60,   286,    0,      2-1,      0,      0,  UPDAT}, //  EXt 
//-----------------------------------------------------------------------------                    
//----------------------------------------------------------------------------------------------------
    {(u8*)DELTA_V, TRACK1, 156,   334,    0,      2-1,      0,      0,  UPDAT}, //  Measure Track    
    {(u8*)NumStr,  TRACK1, 140,   314,    0,      240,     70,   NUM3,  UPDAT}, //  Delta V value 
                                           
    {(u8*)DELTA_T,      4, 124,   334,    0,        0,      0,    0,  UPDAT}, //  Delta T Str     
    {(u8*)NumStr,       4, 108,   314,    0,      300,      80,  NUM3,  UPDAT}, //  Delta T value  T_COLOR 
  //==========================================================================

};


void Display_Trigg(void)
{
  u8  i,Item=0;
  u8  track;
  s32  k, n, m;
  u8  str[10];
//#define V_VERNIE  11
//#define T_VERNIE  13
  for(i=0; i<14; i++)
  {  
    if(i<3)track=Trigg[0].Track;
    else   track=Trigg[i].Track;
            
   // if(Trigg[i].Flag & UPDAT)                 //-----ʾˢµĴĿ
   // { 
      //Trigg[i].Flag &=~UPDAT;
     // Trigg[i].Flag =0;
     switch(i){
     case 7:      //BK_LIGHT, ٷֱ,ٷֱʾ
     case 8:
        Print_Str(
          Trigg[i].XPOS, Trigg[i].YPOS,         // Ҫʾ
          Y_INV[track],                          // Ҫʾɫ(ͨ)
          PRN,                                   // Ҫʾķʽ
          (Trigg[i].Str+(Trigg[i].Value2 *5)));    // ҪʾĿ
        NumStr[0]=' ';
          
        if(Trigg[i].Value1 >=Trigg[i].Limit2)
        {
           NumStr[0]='1';
           NumStr[1]='0';
           NumStr[2]='0';
  
        } else 
        { 
          if(i==7)
            u8ToDec2(NumStr+1, 10*(Trigg[i].Value1+1));
          else
            u8ToDec2(NumStr+1, 10*(Trigg[i].Value1));
        }           
        Print_Str(
            Trigg[i].XPOS+40, Trigg[i].YPOS,
            Y_INV[track],                  // Color fixed  
            PRN, 
            NumStr);                        // String for numerical
        Print_Str(
            Trigg[i].XPOS+64, Trigg[i].YPOS,
            Y_INV[track],                  // Color fixed  
            PRN, 
            "%" );                       
               
      break;

     case   11:
     {
       Int32String_sign(&Num,(_V1_Vernie - _V2_Vernie)*_Meas_V_Scale );
       Print_Str(
          Trigg[i].XPOS, Trigg[i].YPOS,
          Y_INV[Trigg[0].Track],     // Color fixed  Title[i][j].Color[_Meas_V_Track]
          PRN, 
          Num.str);                                // String for numerical
      Print_Str(
          Trigg[i].XPOS+32, Trigg[i].YPOS,
          Y_INV[Trigg[0].Track],      // Color fixed  Trigg[i][j].Color[_Meas_V_Track]
          PRN, 
          V_Unit[Num.decPos]);                     // String variable
     }
     break;
     case 13:     //T_VERNIE
        {  
          m = 1;  n = 1;
          k = _T_Range;
          if(k < 9)  m = pow(10, (11-k)/3);
          else       n = pow(10, (k- 9)/3);
          k = X_Attr[(k%3)+9].SCALE *(_T2 - _T1);
          if(k > 0)
          { if(k <=  0x7FFFFFFF/m)  k = (m * k)/n;
            else                    k = 0x80000000;
          } 
          else 
          {
            if((-k)> 0x7FFFFFFF/m)  k = (m * k)/n;
            else                    k = 0x80000000;
          }
          Int32String_sign(&Num, k);//((_T2 - _T1)*X_Attr[k].SCALE)/n);
//              Int32String_sign(&Num, m*(k *(_T2 - _T1)/n));//((_T2 - _T1)*X_Attr[k].SCALE)/n);
          Print_Str(
                Trigg[i].XPOS, Trigg[i].YPOS,
                Y_INV[track],                   // Color fixed Title[i][j].Color[0], 
                PRN, 
                Num.str                                // String for numerical
              );
              Print_Str(
                Trigg[i].XPOS + 40, Trigg[i].YPOS,
                Y_INV[track],                   // Color fixed Title[i][j].Color[0], 
                PRN, 
                T_Unit[Num.decPos]                     // String variable
              );
          }
          
      break;
      default:
           Print_Str(
              Trigg[i].XPOS, Trigg[i].YPOS,         // Ҫʾ
              Y_INV[track],                          // Ҫʾɫ(ͨ)
              PRN,                                   // Ҫʾķʽ
              (Trigg[i].Str+(Trigg[i].Value2 *5)));    // ҪʾĿ
        break; 
    }//switch end
  }
  if((CurrCom >= 0)&&(CurrCom <= 11))
  {//-----ʾ˸ĲĿ
      i = CurrCom;
      if(i<3)track=Trigg[0].Track;
      else   track=Trigg[i].Track;
      Print_Str(
      Trigg[i].XPOS, Trigg[i].YPOS,          // Ҫ˸ 
      Y_INV[track],                           // Ҫ˸ɫ(ͨ)
      Twink,                                  // ˸ʽ
      (Trigg[i].Str +(Trigg[i].Value2 *5)));    // Ҫ˸Ŀ
  }

}        
void show_notice(void)
{
  u16 i;
  u8 color,type;
  if(Notice_Flag==0)
  { BLOCK_HIDE=1;
     Draw_Window();
    __LCD_DMA_Ready();
    return;
  }
  BLOCK_HIDE=0;
  for(i=0;i<1500;i++) Block[i]=0;
  Bx1 =360-6*16; Bx2 = 360; 
  switch (Notice_Flag){
  case Meter_Flag://
    By1 = 2; By2 =By1+9*16;
    NoteSide(2); 
    for(i=0; i<8; ++i)
    { type=1;       
      Nx0=4; Ny0 =(8-i)*16-4;//(u8*)&METER[i][0]
      color=Meter[i].Track;
      color++;
      if(color>3){color=3;type=0;}
      NoteSTR(color, type,(Meter[i].Str+(Meter[i].Item * 5)));
    }
    break;
  case Trigg_Flag:
    //USART1Write("Trigg_Flag...\r\n",15);
    By1 =200-4*16; By2 =200;//By1+4*16+8;
    NoteSide(2); 
    //for(i=0; i<3; i++)
    {        
      Nx0=4; Ny0 =3*16;//(3-0)
      NoteSTR(4, 1, (Trigg[1].Str+Trigg[1].Value2*5));
      Nx0=4; Ny0 =2*16;//(3-0)
      color=Trigg[1].Track+1;
      NoteSTR(color, 1, Trigg[10].Str);
      
      Int32String_sign(&Num,(_V1_Vernie - _V2_Vernie)*_Meas_V_Scale );
      Nx0=4+4*8; Ny0 =2*16;
      NoteSTR(color, 1, Num.str);//V_Unit[Num.decPos]
      Nx0=4; Ny0 =1*16;
      NoteSTR(4, 1, Trigg[12].Str);
      Nx0=4+4*8; Ny0 =1*16;
      NoteSTR(4, 1, Trigg[13].Str);
    }
    break;
  case Info_Flag:
    break;
  case (Meter_Flag|Trigg_Flag):
    USART1Write("\r\nMeter & Trigg....",15);
    By1 =4; By2 =16*12+4;
    NoteSide(2); 
    for(i=0; i<8; ++i)
    {        
      Nx0=4; Ny0 =(8-i)*16-By1;
      NoteSTR(2, 0, (Meter[i].Str+(Meter[i].Item * 5)));//
    }
    for(i=2; i>0; --i)
    {        
      Nx0=4; Ny0 =(8+(2-i))*16+4;
      NoteSTR(3, 0, Title[(i-1)+8][0].Str);
    }
    break;
  case (Meter_Flag|Trigg_Flag|Info_Flag):
    By1 = 0; By2 = 160+16*4;
    break;
  }
  Draw_Window();
  __LCD_DMA_Ready();
}
void Display_Meter(void)                  // ÿˢʾһ
{
  u8  i;
  for(i=0; i<9; ++i){        
    if(Meter[i].Flag & UPDAT){            //-----ʾˢµĲĿ
      //Meter[i].Flag &= (~UPDAT | ~BLINK);       // Clr Update & Blink flag
     Meter[i].Flag =0;
      Print_Str
        (Meter[i].XPOS1, Meter[i].YPOS,        // Ҫʾ
         Y_INV[Meter[i].Track],                // Ҫʾɫ(ͨ)
         PRN,                                  // Ҫʾķʽ
         (Meter[i].Str +(Meter[i].Item * 5)));   // ҪʾĿ
    } 
  }
  if((CurrCom >= METER_0)&&(CurrCom <= METER_8))
  {//-----ʾ˸ĲĿ
      i = CurrCom;
      Print_Str(
      Meter[i].XPOS1, Meter[i].YPOS,         // Ҫ˸ 
      Y_INV[Meter[i].Track],                 // Ҫ˸ɫ(ͨ)
      Twink,                                 // ˸ʽ
      (Meter[i].Str +(Meter[i].Item *5)));     // Ҫ˸Ŀ
  }

}

void Display_Value(u8 i)
{
  s32 Tmp = 0;
  u8* Ptr;
  u8  Offset= 40;
  u8  DUT_STR[3] = "% ";
  u8  FPS_STR[6] = "/Sec.";
  u16 Kp;
  u32 k, n, m;
  u8 str[10];
  if(Interlace == 0) Kp = _Kp1; // ģʽ
  else               Kp = _Kp2; // ģʽ  
  k = _T_Range;
  m = 1;  n = 1;
  if(k < 9)  m = pow(10, (11-k)/3);
  else       n = pow(10, (k- 9)/3);
  k = X_Attr[(k%3)+9].SCALE;
  switch (Meter[i].Item){  
  case VBT://--------------- ʾصѹ ---------------
    Tmp = __Get(V_BATTERY)* 1000;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case FPS://--------------- ʾ֡ ---------------
    Tmp = Result_FPS & 0x7F;
    Int32String(&Num, Tmp, 2);
    Ptr = FPS_STR;
    Offset = 16;
    break;  
  case VPP:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A))
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*a_Vpp + 512)/1024)* Y_Attr[_A_Range].SCALE;
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*b_Vpp + 512)/1024)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case VDC:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A))
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*a_Vdc + 512)/1024)* Y_Attr[_A_Range].SCALE;
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*b_Vdc + 512)/1024)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case RMS:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A))
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*Int_sqrt(a_Ssq/4096)+ 512)/1024)* Y_Attr[_A_Range].SCALE;
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*Int_sqrt(b_Ssq/4096)+ 512)/1024)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case MAX:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A)&&((a_Vdc != 0)||(a_Vpp != 0)))
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*a_Max + 512)/1024 - _1_posi)* Y_Attr[_A_Range].SCALE;
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*b_Max + 512)/1024 - _2_posi)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case MIN:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A)&&((a_Vdc != 0)||(a_Vpp != 0)))
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*a_Min + 512)/1024 - _1_posi)* Y_Attr[_A_Range].SCALE;
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*b_Min + 512)/1024 - _2_posi)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case FRQ:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A))
      Tmp = 2000*((500000 * a_Tcnt)/a_Tcs);
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = 2000*((500000 * b_Tcnt)/b_Tcs);
    if((Meter[i].Track == TRACK3)&&(_3_source == CH_C))
      Tmp = 2000*((500000 * c_Tcnt)/c_Tcs);
    if((Meter[i].Track == TRACK4)&&(_4_source == CH_D))
      Tmp = 2000*((500000 * d_Tcnt)/d_Tcs);
    if(n < 10) Tmp = ((250*(Tmp/(k/60)))/m)/15;
    else       Tmp = Kp*(n*(Tmp/(k/60))/240)/256;
    Int32String(&Num, Tmp, 4);
    if(n < 10) Ptr = F_Unit[Num.decPos];
    else       Ptr = F_Unit[Num.decPos +1];
    break;  
  case CIR:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A))
      Tmp = (k * a_Tcs)/a_Tcnt;
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = (k * b_Tcs)/b_Tcnt;
    if((Meter[i].Track == TRACK3)&&(_3_source == CH_C))
      Tmp = (k * c_Tcs)/c_Tcnt;
    if((Meter[i].Track == TRACK4)&&(_4_source == CH_D))
      Tmp = (k * d_Tcs)/d_Tcnt;
    if(Tmp <= 0x7FFFFFFF/m) Tmp = (m*((1024 * Tmp)/Kp))/n;
    else                    Tmp = 0x80000000;
    Int32String(&Num, Tmp, 4);
    Ptr = T_Unit[Num.decPos];
    break;
  case DUT:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A))
      Tmp = ((100000*a_Pws)/a_Pcnt)/(a_Tcs/a_Tcnt);
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = ((100000*b_Pws)/b_Pcnt)/(b_Tcs/b_Tcnt);
    if((Meter[i].Track == TRACK3)&&(_3_source == CH_C))
      Tmp = ((100000*c_Pws)/c_Pcnt)/(c_Tcs/c_Tcnt);
    if((Meter[i].Track == TRACK4)&&(_4_source == CH_D))
      Tmp = ((100000*d_Pws)/d_Pcnt)/(d_Tcs/d_Tcnt);
    Int32String(&Num, Tmp, 4);
    Ptr = DUT_STR;
    break;
  case TH:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A))
      Tmp = (k * a_Tcs)/a_Tcnt;
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = (k * b_Tcs)/b_Tcnt;
    if((Meter[i].Track == TRACK3)&&(_3_source == CH_C))
      Tmp = (k * c_Tcs)/c_Tcnt;
    if((Meter[i].Track == TRACK4)&&(_4_source == CH_D))
      Tmp = (k * d_Tcs)/d_Tcnt;
    if(Tmp <= 0x7FFFFFFF/m) Tmp = (m*((1024 * Tmp)/Kp))/n;
    else                    Tmp = 0x80000000;
    Int32String(&Num, Tmp, 4);
    Ptr = T_Unit[Num.decPos];
    break;
  case TL:
    if((Meter[i].Track == TRACK1)&&(_1_source == CH_A))
      Tmp = (k * a_Tcs)/a_Tcnt;
    if((Meter[i].Track == TRACK2)&&(_2_source == CH_B))
      Tmp = (k * b_Tcs)/b_Tcnt;
    if((Meter[i].Track == TRACK3)&&(_3_source == CH_C))
      Tmp = (k * c_Tcs)/c_Tcnt;
    if((Meter[i].Track == TRACK4)&&(_4_source == CH_D))
      Tmp = (k * d_Tcs)/d_Tcnt;
    if(Tmp <= 0x7FFFFFFF/m) Tmp = (m*((1024 * Tmp)/Kp))/n;
    else                    Tmp = 0x80000000;
    Int32String(&Num, Tmp, 4);
    Ptr = T_Unit[Num.decPos];
    break;
    }
    
/*  Print_Str(
    Meter[i].XPOS2, Meter[i].YPOS,
    Y_COLOR[Meter[i].Track], 
    PRN,
    Num.str);                              // ʾֵ
  Print_Str(
    Meter[i].XPOS2 + Offset, Meter[i].YPOS,
    Y_COLOR[Meter[i].Track], 
    PRN,
    Ptr);  */                 // ʾ
    Nx0=4+8*4; Ny0 =(8-i)*16-4;
    NoteSTR(2, 0, Num.str);
    Nx0=(36+Offset); Ny0 =(8-i)*16-4;
    NoteSTR(2, 0, Ptr);
                                    
}
void ExitMeter(u8 Item)
{
  display_flag=1;
  Curr_Status=S_Title;
  BLOCK_HIDE=1;
  Draw_Window();
  __LCD_DMA_Ready();
 /* switch (Curr_Status)
  { 
    case S_Title:
      break;
    case S_Trigg:
      Current=CurrCom;
      ITEM1=0;
      ITEM2=MENU_ITEM;
      break;
    default:
      break;      
  }*/
}

void SetMeter(u8 Item)
{u32 j;
  u8 track,i;
  
  BLOCK_HIDE=0;
  for(j=0;j<1500;j++) Block[j]=0;  
  switch(Item){
    case 1:
      display_flag=0;
      Curr_Status=S_Meter;
      CurrCom=METER_0;
      Meter[CurrCom].Flag= UPDAT;
      Bx1 =360-5*8; Bx2 = 360; 
      By1 = 4; By2 =By1+9*16;
      NoteSide(1); 
      Draw_Window();
      __LCD_DMA_Ready();
      for(i=0; i<9; ++i)
      {        
        Print_Str
        ( Meter[i].XPOS1, Meter[i].YPOS,        // Ҫʾ
          Y_INV[Meter[i].Track],                // Ҫʾɫ(ͨ)
          PRN,                                  // Ҫʾķʽ
          (Meter[i].Str +(Meter[i].Item * 5))   // ҪʾĿ
        );   
      }
      
    break; 
    case 2:
      Curr_Status=S_Trigg;
      CurrCom=0;
      Trigg[CurrCom].Flag|= UPDAT;
      Bx1 =360-11*8; Bx2 = 360; 
      By1 = 40; By2 =40+10*16;
      NoteSide(1); 
      Draw_Window();
      __LCD_DMA_Ready();
     for(i=0; i<13; i++)
     {  if(i<3)track=Trigg[0].Track;
        else   track=Trigg[i].Track; 
        Print_Str( 
          Trigg[i].XPOS, Trigg[i].YPOS,        // Ҫʾ
          Y_INV[track],                // Ҫʾɫ(ͨ)
          PRN,                                  // Ҫʾķʽ
          (Trigg[i].Str +(Trigg[i].Value2 *5)));   // ҪʾĿ
     }
   break;
   }//switch end
}

void Show_Title(void)
{
  u8 i,j,Color_fixed,type;


  __LCD_DMA_Ready();
  for(i=0;i<MENU_ITEM;i++)//MENU_ITEM
  {
    for(j=0;j<3;j++)
    {
      if(Title[i][j].Flag & UPDAT)
      {   // ҪˢµItem
          Title[i][j].Flag &= ~UPDAT;   // Clr Update flag 
        if((Current == i)&&(Detail[i] == j))
          type=Twink;
        else 
          type=PRN;
        if((i==4)&&(j==0))
          Color_fixed=_State.Value;
        else 
          Color_fixed=0;
        if(i<4)Show[i]=Title[i][0].Value;
         switch (Title[i][j].MARK){ 
          case FIX: 
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Color_fixed],                   
              type, 
              Title[i][j].Str);
          break;
          case 0:
          case CIRC:
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Color_fixed],                    // Color fixed 
              type, 
              Title[i][j].Str +(Title[i][j].Value * 10));
          break;
        }//switch end
     }
   }//for j end
 }//FOR I END
 
}           
/*
void Show_Title(u8 Item1,u8 Item2)
{
  u8 i,j,Color_fixed,type;
  s32  k, n, m;
  u8 ItemNum;
  u8 str[10];
  if(Curr_Status==S_Trigg)
    ItemNum=1;
  else
    ItemNum=3;
  __LCD_DMA_Ready();
  for(i=Item1;i<Item2;i++)//MENU_ITEM
  {
    for(j=0;j<3;j++)
    {
      if(Title[i][j].Flag & UPDAT)
      {   // ҪˢµItem
          Title[i][j].Flag &= ~UPDAT;   // Clr Update flag 

        if((Current == i)&&(Detail[i] == j))
          type=Twink;
        else 
          type=PRN;
        switch(Title[i][j].MARK){
          case FIX:
            if((i == BATTERY)||(i == TRIGG))
            {  
              Color_fixed=Title[i][j].Color[Title[i][0].Value];
              __LCD_DMA_Ready(); 
             }
             else
              Color_fixed=Title[i][j].Color[0];
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[0],                   // Color fixed Title[i][j].Color[0], Color_fixed
              type, 
              Title[i][j].Str);
                                      // String fixed
            break;
          case NOT:
            if((i == BATTERY)||(i == TRIGG)){
              Print_Str(
                Title[i][j].XPOS, Title[i][j].YPOS,
                Title[i][j].Color[Title[i][0].Value],    // Color variable 
                type, 
                Title[i][j].Str +(Title[i][j].Value * 10));// String variable
             }
             else
             {
                if(i == T_VERNIE)
                {
                  Print_Str(
                    Title[i][j].XPOS, Title[i][j].YPOS,
                    Title[i][j].Color[0],                    // Color fixed 
                    type, 
                    Title[i][j].Str );                          // String variable
                }
              }  
            break;
           case NUM3:
            switch (i){
             /* case V_VERNIE:
                Int32String_sign(&Num,(_V1_Vernie - _V2_Vernie)* _Meas_V_Scale);
                Print_Str(Title[i][j].XPOS, Title[i][j].YPOS,
                  Title[i][j].Color[_Meas_V_Track],      // Color fixed  
                  type, 
                  Num.str);                                // String for numerical
                Print_Str(Title[i][j].XPOS + 40, Title[i][j].YPOS,
                  Title[i][j].Color[_Meas_V_Track],      // Color fixed  
                  type, 
                  V_Unit[Num.decPos]);                     // String variable
                break;
              case T_VERNIE:
                m = 1;  n = 1;
                k = _T_Range;
                if(k < 9)  m = pow(10, (11-k)/3);
                else       n = pow(10, (k- 9)/3);
                k = X_Attr[(k%3)+9].SCALE *(_T2 - _T1);
                if(k > 0){
                  if(k <=  0x7FFFFFFF/m)  k = (m * k)/n;
                  else                    k = 0x80000000;
                } else {
                if((-k)> 0x7FFFFFFF/m)  k = (m * k)/n;
                else                    k = 0x80000000;
              }
              Int32String_sign(&Num, k);//((_T2 - _T1)*X_Attr[k].SCALE)/n);
//              Int32String_sign(&Num, m*(k *(_T2 - _T1)/n));//((_T2 - _T1)*X_Attr[k].SCALE)/n);
              Print_Str(
                Title[i][j].XPOS, Title[i][j].YPOS,
                Title[i][j].Color[0],                  // Color fixed  
                type, 
                Num.str);                                // String for numerical
              Print_Str(
                Title[i][j].XPOS + 40, Title[i][j].YPOS,
                Title[i][j].Color[0],                  // Color fixed  
                type, 
                T_Unit[Num.decPos] );                     // String variable
                break;
              case FILE:
                u8ToDec3(Title[i][1].Str, Title[i][1].Value);
                Print_Str(
                  Title[i][1].XPOS, Title[i][1].YPOS,
                  Title[i][1].Color[0],                  // Color fixed  
                  type, 
                  Title[i][1].Str );                       // String for numerical
                  break;
            };
            break;
          case NUM2:
            NumStr[0]=' ';
            if(i == BK_LIGHT){                        // ٷֱʾ
              if(Title[i][j].Value == 9){
                NumStr[0]='1';
                NumStr[1]='0';
                NumStr[2]='0';
              } else  
                u8ToDec2(NumStr+1, 10*(Title[i][j].Value+1)); 
            } else {                                  // ٷֱʾ
              if(Title[i][j].Value == 10){
                NumStr[0]='1';
                NumStr[1]='0';
                NumStr[2]='0';
              } else  u8ToDec2(NumStr+1, 10*Title[i][j].Value); 
            }
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[0],                  // Color fixed  
              type, 
              NumStr);                       // String for numerical
            Print_Str(
              Title[i][j].XPOS+24, Title[i][j].YPOS,
              Title[i][j].Color[0],                  // Color fixed  
              type, 
              "%" );                       
            break;
          case 0:
          case CIRC:
          default:
              if(i == V_VERNIE)
              {
                Print_Str(
                  Title[i][j].XPOS, Title[i][j].YPOS,
                  Title[i][j].Color[_Meas_V_Track],         // Color variable 
                  type, 
                  Title[i][j].Str +(Title[i][j].Value * 10)); // String variable
              }
              else 
              {
                if((i==4)&&(j==0))Color_fixed=_State.Value;
                else Color_fixed=0;
                  
                Print_Str(
                  Title[i][j].XPOS, Title[i][j].YPOS,
                  Title[i][j].Color[Color_fixed],                    // Color fixed 
                  type, 
                  Title[i][j].Str +(Title[i][j].Value * 10));// String variable
              }
              break;
           }//switch end
      }    
    } //(for j end)   
  }//(for i end)  
}*/



/*
void Display_Title(void)
{
  u16  i, j;
  s32  k, n, m;
  
  for(i = TRACK1; i <= VOLUME; ++i){
    for(j = 0; j < 4; ++j){
      if(Title[i][j].Flag & UPDAT){   // ҪˢµItem
        Title[i][j].Flag &= ~UPDAT;   // Clr Update flag 
        if((i == BATTERY)||(i == TRIGG)){
          if(Title[i][j].MARK & FIX){                  // ---- Under fix mode
            Print_Str( 
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Title[i][0].Value],    // Color variable 
              PRN, 
              Title[i][j].Str                          // String fixed
            );                    
          } else if(!(Title[i][j].MARK & NOT)){        // ---- Under other mode
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Title[i][0].Value],    // Color variable 
              PRN, 
              Title[i][j].Str +(Title[i][j].Value * 10)// String variable
            ); 
          }
        } else {
          if(Title[i][j].MARK & FIX){                  // ---- Under fix mode
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[0],                    // Color fixed 
              PRN, 
              Title[i][j].Str                          // String fixed
             );
          } else if(Title[i][j].MARK & NUM3){          // ---- Under NUM3 mode
            if(i == V_VERNIE){
              Int32String_sign(&Num,(_V1_Vernie - _V2_Vernie)* _Meas_V_Scale);
              Print_Str(
                Title[i][j].XPOS, Title[i][j].YPOS,
                Title[i][j].Color[_Meas_V_Track],      // Color fixed  
                PRN, 
                Num.str                                // String for numerical
              );
              Print_Str(
                Title[i][j].XPOS + 40, Title[i][j].YPOS,
                Title[i][j].Color[_Meas_V_Track],      // Color fixed  
                PRN, 
                V_Unit[Num.decPos]                     // String variable
              );
            }
            if(i == T_VERNIE){
              m = 1;  n = 1;
              k = _T_Range;
              if(k < 9)  m = pow(10, (11-k)/3);
              else       n = pow(10, (k- 9)/3);
              k = X_Attr[(k%3)+9].SCALE *(_T2 - _T1);
              if(k > 0){
                if(k <=  0x7FFFFFFF/m)  k = (m * k)/n;
                else                    k = 0x80000000;
              } else {
                if((-k)> 0x7FFFFFFF/m)  k = (m * k)/n;
                else                    k = 0x80000000;
              }
              Int32String_sign(&Num, k);//((_T2 - _T1)*X_Attr[k].SCALE)/n);
//              Int32String_sign(&Num, m*(k *(_T2 - _T1)/n));//((_T2 - _T1)*X_Attr[k].SCALE)/n);
              Print_Str(
                Title[i][j].XPOS, Title[i][j].YPOS,
                Title[i][j].Color[0],                  // Color fixed  
                PRN, 
                Num.str                                // String for numerical
              );
              Print_Str(
                Title[i][j].XPOS + 40, Title[i][j].YPOS,
                Title[i][j].Color[0],                  // Color fixed  
                PRN, 
                T_Unit[Num.decPos]                     // String variable
              );
            }
            if(i == FILE){
              u8ToDec3(Title[i][1].Str, Title[i][1].Value);
              Print_Str(
                Title[i][1].XPOS, Title[i][1].YPOS,
                Title[i][1].Color[0],                  // Color fixed  
                PRN, 
                Title[i][1].Str                        // String for numerical
              );
            }
          } else if(Title[i][j].MARK == NUM2){ 
                NumStr[0]=' ';
            if(i == BK_LIGHT){                        // ٷֱʾ
              if(Title[i][j].Value == 9){
                NumStr[0]='1';
                NumStr[1]='0';
                NumStr[2]='0';
              } else  
                u8ToDec2(NumStr+1, 10*(Title[i][j].Value+1)); 
            } else {                                  // ٷֱʾ
              if(Title[i][j].Value == 10){
                NumStr[0]='1';
                NumStr[1]='0';
                NumStr[2]='0';
              } else  u8ToDec2(NumStr+1, 10*Title[i][j].Value); 
            }
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[0],                  // Color fixed  
              PRN, 
              NumStr                        // String for numerical
            );
            Print_Str(
              Title[i][j].XPOS+24, Title[i][j].YPOS,
              Title[i][j].Color[0],                  // Color fixed  
              PRN, 
              "%"                        
            );
          } else if(Title[i][j].MARK != NOT){
          
            if(i == V_VERNIE){
              Print_Str(
                Title[i][j].XPOS, Title[i][j].YPOS,
                Title[i][j].Color[_Meas_V_Track],         // Color variable 
                PRN, 
                Title[i][j].Str +(Title[i][j].Value * 10)// String variable
              ); 
            } else {
              Print_Str(
                Title[i][j].XPOS, Title[i][j].YPOS,
                Title[i][j].Color[0],                    // Color fixed 
                PRN, 
                Title[i][j].Str +(Title[i][j].Value * 10)// String variable
              ); 
            }
          } else if(i == T_VERNIE){
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[0],                    // Color fixed 
              PRN, 
              Title[i][j].Str                          // String variable
            ); 
          }
        }
      } else if((Current == i)&&(Detail[i] == j)&&(Blink)){ // ǰλõItem
        Blink = 0;
        if((i == BATTERY)||(i == TRIGG)){
          if((Title[i][j].MARK & FIX)){      // ---- Under fix mode
            Print_Str( 
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Title[i][0].Value],    // Color variable 
              Twink, 
              Title[i][j].Str                          // String fixed
            );                    
          } else {                                // ---- Under other mode
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Title[i][0].Value],    // Color variable 
              Twink, 
              Title[i][j].Str +(Title[i][j].Value * 10)// String variable
            ); 
          }
        } else {
          if(Title[i][j].MARK & FIX){             // ---- Under fix mode
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[0],                    // Color fixed 
              Twink, 
              Title[i][j].Str                          // String fixed
            );
     } else if(Title[i][j].MARK != NUM3){
                 if(i == V_VERNIE){
              Print_Str(
                Title[i][j].XPOS, Title[i][j].YPOS,
                Title[i][j].Color[_Meas_V_Track],        // Color variable=
                Twink, 
                Title[i][j].Str +(Title[i][j].Value * 10)// String variable
              ); 
            } else {
              Print_Str(
                Title[i][j].XPOS, Title[i][j].YPOS,
                Title[i][j].Color[0],                    // Color fixed 
                Twink, 
                Title[i][j].Str +(Title[i][j].Value * 10)// String variable
              ); 
      }
                  }
            if((i == FILE)&&(Title[i][j].MARK & NUM3)){
              u8ToDec3(Title[i][1].Str, Title[i][1].Value);
              Print_Str(
                Title[i][1].XPOS, Title[i][1].YPOS,
                Title[i][1].Color[0],                  // Color fixed  
                Twink, 
                Title[i][1].Str                        // String for numerical
              );
            }
//          }
        }
      }
    }
  }
}*/
/*******************************************************************************
 Load_Attr:  Ӳ
*******************************************************************************/
void Load_Attr(void)
{
  u16 i;
  
  for(i=0; i<G_Attr[0].Yp_Max+1; ++i) 
    strcpy(&Vertical[i][0], Y_Attr[i].STR);
  Title[TRACK1][RANGE].Limit = G_Attr[0].Yp_Max;
  Title[TRACK2][RANGE].Limit = G_Attr[0].Yp_Max;
  Title[TRACK3][RANGE].Limit = 0;
  Title[TRACK4][RANGE].Limit = 0;
  
  for(i=0; i<G_Attr[0].Xp_Max+6; ++i) 
    strcpy(&BaseStr[i][0], X_Attr[i].STR);
  Title[T_BASE][BASE].Limit = G_Attr[0].Xp_Max;
  
}
/*******************************************************************************
 Update_Battery:  ˢµصָʾ
*******************************************************************************/
void Update_Battery(void)
{
  u16 Vb, Level;
  
  Vb = __Get(V_BATTERY);
  Level =0;
  if(Vb > 3000 ) Level +=1;
  if(Vb > 3500 ) Level +=1;
  if(Vb > 3900 ) Level +=1;
  if(Vb > 4100 ) Level +=1;
  Print_Str(
    Title[4][1].XPOS, Title[4][1].YPOS,
    Title[4][1].Color[Level], 
    PRN,
    (Title[4][1].Str + Level*10) 
  );    
}
/******************************** END OF FILE *********************************/
